/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class DisplayTableBlockEntity
extends AbstractPneumaticCraftBlockEntity
implements IComparatorSupport {
    private final DisplayItemHandler inventory = new DisplayItemHandler(this, 1);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    public ItemStack displayedStack = ItemStack.f_41583_;

    public DisplayTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DISPLAY_TABLE.get(), pos, state);
    }

    DisplayTableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Items"));
        this.displayedStack = this.inventory.getStackInSlot(0);
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        tag.m_128365_("Item", (Tag)this.displayedStack.m_41739_(new CompoundTag()));
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.displayedStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
    }

    @Override
    public int getComparatorValue() {
        return this.inventory.getStackInSlot(0).m_41619_() ? 0 : 15;
    }

    class DisplayItemHandler
    extends BaseItemStackHandler {
        DisplayItemHandler(DisplayTableBlockEntity te, int size) {
            super(te, size);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                DisplayTableBlockEntity.this.displayedStack = this.getStackInSlot(0);
                if (!DisplayTableBlockEntity.this.nonNullLevel().f_46443_) {
                    DisplayTableBlockEntity.this.sendDescriptionPacket();
                }
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

